/*
 * Decompiled with CFR 0.152.
 */
package pl.unizeto.socrates.cryptoagent.crypto.agent.guice;

import com.google.common.eventbus.EventBus;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import iaik.cms.SecurityProvider;
import iaik.security.provider.IAIK;
import iaik.xml.crypto.XSecProvider;
import java.io.File;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.jnlp.BasicService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.unizeto.socrates.cryptoagent.c.c;
import pl.unizeto.socrates.cryptoagent.crypto.agent.a;
import pl.unizeto.socrates.cryptoagent.crypto.agent.base.option.Options;
import pl.unizeto.socrates.cryptoagent.crypto.agent.gui.b;
import pl.unizeto.socrates.cryptoagent.crypto.agent.gui.base.g;

public class CryptoAgentModule
extends AbstractModule {
    private static final File USER_APP_DIR = new File(System.getProperty("user.home"), ".CertumCryptoAgent");
    private static final String DEFAULT_PORT = "8025";
    private final Logger log = LoggerFactory.getLogger(CryptoAgentModule.class);
    private final Locale locale;
    private final Options options;
    private final a properties;

    public CryptoAgentModule(Options options) {
        this.options = options;
        this.locale = options.getLocale().orElseGet(() -> new Locale("pl"));
        this.properties = a.getInstance();
        this.log.info("J\u0119zyk aplikacji: {}", (Object)this.locale);
        Security.addProvider((Provider)new pl.unizeto.procertum.k.a.a());
        Security.addProvider((Provider)new IAIK());
        Security.addProvider((Provider)new XSecProvider());
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.log.debug("Zarejestrowano dostawc\u00f3w kryptograficznych. Lista po aktualizacji: {}", (Object)Arrays.toString(Security.getProviders()));
        SecurityProvider.setSecurityProvider((SecurityProvider)new pl.unizeto.procertum.k.c());
        this.createDirectories();
        this.log.info("Platforma {}, system {}", (Object)System.getProperty("os.arch"), (Object)System.getProperty("os.name"));
    }

    private void createDirectories() {
        pl.unizeto.socrates.cryptoagent.crypto.agent.base.b.a.createDirectory((File)USER_APP_DIR);
    }

    protected void configure() {
        this.bindProperties();
        this.bindSettingsQualifiers();
        this.bind(EventBus.class).toInstance((Object)new EventBus());
        this.bind(g.class).to(b.class);
        this.bind(Options.class).toInstance((Object)this.options);
        this.bind(Locale.class).toInstance((Object)this.locale);
        this.bind(pl.unizeto.socrates.cryptoagent.crypto.agent.base.c.b.class).toInstance((Object)this.createLicenseStorage());
        this.bind(c.class).to(pl.unizeto.socrates.cryptoagent.c.a.a.class).asEagerSingleton();
        this.bind(pl.unizeto.socrates.cryptoagent.crypto.agent.base.f.a.class).to(pl.unizeto.socrates.cryptoagent.crypto.agent.d.a.class);
        this.bind(pl.unizeto.socrates.cryptoagent.crypto.agent.base.e.a.class).toInstance((Object)new pl.unizeto.socrates.cryptoagent.crypto.agent.c.a());
    }

    private void bindSettingsQualifiers() {
        this.bind((TypeLiteral)new TypeLiteral<File>(){}).annotatedWith(pl.unizeto.socrates.cryptoagent.crypto.agent.base.d.a.class).toInstance((Object)USER_APP_DIR);
    }

    private void bindProperties() {
        Properties properties = new Properties();
        properties.setProperty("server.hostname", "wss.cryptoagent.certum.pl");
        List<String> list = this.options.getPorts().orElse(Collections.singletonList(DEFAULT_PORT));
        pl.unizeto.socrates.cryptoagent.crypto.agent.server.b.b b2 = new pl.unizeto.socrates.cryptoagent.crypto.agent.server.b.b(list);
        String string = DEFAULT_PORT;
        try {
            string = String.valueOf(b2.getNext());
        }
        catch (pl.unizeto.socrates.cryptoagent.crypto.agent.server.a.a a2) {
            this.log.debug("Nie mo\u017cna pobra\u0107 portu");
        }
        properties.setProperty("server.port", string);
        Names.bindProperties((Binder)this.binder(), (Properties)properties);
    }

    private pl.unizeto.socrates.cryptoagent.crypto.agent.base.c.b createLicenseStorage() {
        pl.unizeto.socrates.cryptoagent.crypto.agent.base.c.a a2 = null;
        BasicService basicService = null;
        String string = null;
        try {
            basicService = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
            string = basicService.getCodeBase().getHost();
            int n = Integer.valueOf(this.properties.getProperty("license.type"));
            a2 = new pl.unizeto.socrates.cryptoagent.crypto.agent.b.a().getLicenseInfo(string, n);
        }
        catch (UnavailableServiceException unavailableServiceException) {
            this.log.error("Could not get license info. Application probably was not started from jnlp file.", (Throwable)unavailableServiceException);
            a2 = pl.unizeto.socrates.cryptoagent.crypto.agent.base.c.a.NO_LICENSE;
        }
        return new pl.unizeto.socrates.cryptoagent.crypto.agent.b.b(a2, string);
    }
}

