/*
 * Decompiled with CFR 0.152.
 */
package pl.unizeto.socrates.cryptoagent.crypto.agent.guice;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.unizeto.socrates.cryptoagent.crypto.agent.base.option.Options;
import pl.unizeto.socrates.cryptoagent.crypto.agent.c;

public class CryptoAgentInjector {
    private static final Logger LOG = LoggerFactory.getLogger(CryptoAgentInjector.class);
    private static Injector injector;

    public static void init(Options options) {
        if (injector != null) {
            throw new IllegalArgumentException("Obiekt zosta\u0142 ju\u017c zainicjalizowany");
        }
        Modules modules = new Modules();
        modules.addModule("pl.unizeto.socrates.cryptoagent.crypto.agent.guice.CryptoAgentModule", clazz -> clazz.getConstructor(Options.class).newInstance(options));
        modules.addModule("pl.unizeto.socrates.cryptoagent.crypto.agent.gui.guice.CryptoAgentGuiModule");
        modules.addModule("pl.unizeto.socrates.cryptoagent.crypto.agent.server.websocket.guice.CryptoAgentServerModule");
        modules.addModule("pl.unizeto.socrates.cryptoagent.command.add.certificate.guice.AddCertificateModule");
        modules.addModule("pl.unizeto.socrates.cryptoagent.command.certificate.selection.guice.CertificateSelectionModule");
        modules.addModule("pl.unizeto.socrates.cryptoagent.command.change.pin.guice.ChangePinModule");
        modules.addModule("pl.unizeto.socrates.cryptoagent.command.close.application.guice.CloseApplicationModule");
        modules.addModule("pl.unizeto.socrates.cryptoagent.command.version.guice.VersionModule", clazz -> clazz.getConstructor(Class.class).newInstance(c.class));
        modules.addModule("pl.unizeto.socrates.cryptoagent.command.generate.key.guice.GenerateKeyModule");
        modules.addModule("pl.unizeto.socrates.cryptoagent.command.sign.guice.SignModule");
        modules.addModule("pl.unizeto.socrates.cryptoagent.command.generate.csr.guice.GenerateCsrModule");
        modules.addModule("pl.unizeto.socrates.cryptoagent.command.wrap.key.guice.WrapKeyModule");
        modules.addModule("pl.unizeto.socrates.cryptoagent.command.show.certificate.guice.ShowCertificateModule");
        modules.addModule("pl.unizeto.socrates.cryptoagent.command.show.signature.guice.ShowSignatureModule");
        modules.addModule("pl.unizeto.socrates.cryptoagent.command.get.pin.info.guice.GetPinInfoModule");
        modules.addModule("pl.unizeto.socrates.cryptoagent.command.get.cards.info.guice.GetCardsInfoModule");
        modules.addModule("pl.unizeto.socrates.cryptoagent.command.set.pin.guice.SetPinModule");
        modules.addModule("pl.unizeto.socrates.cryptoagent.command.set.pairing.key.guice.SetPairingKeyModule");
        modules.addModule("pl.unizeto.socrates.cryptoagent.command.verify.signature.guice.VerifySignatureModule");
        injector = Guice.createInjector(modules.getInstances());
    }

    public static Injector getInjector() {
        if (injector == null) {
            throw new IllegalStateException("Nale\u017cy najpierw wywo\u0142a\u0107 metod\u0119 init()");
        }
        return injector;
    }

    @FunctionalInterface
    private static interface Instaniator {
        public Object newInstance(Class<?> var1);

        default public Module getInstance(Class<?> clazz) {
            try {
                return (Module)this.newInstance(clazz);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                LOG.warn("Nie mo\u017cna za\u0142adowa\u0107 modu\u0142u {}", clazz);
                LOG.debug("Nie mo\u017cna za\u0142adowa\u0107 modu\u0142u " + clazz, (Throwable)reflectiveOperationException);
                return null;
            }
        }
    }

    private static class Modules {
        private final List<Module> instances = new ArrayList<Module>();

        private Modules() {
        }

        public void addModule(String string) {
            this.addModule(string, Class::newInstance);
        }

        public void addModule(String string, Instaniator instaniator) {
            Optional<Module> optional = this.newInstance(string, instaniator);
            if (optional.isPresent()) {
                this.instances.add(optional.get());
            }
        }

        private Optional<Module> newInstance(String string, Instaniator instaniator) {
            try {
                Module module = instaniator.getInstance(Class.forName(string));
                if (module != null) {
                    LOG.info("Za\u0142adowano modu\u0142 {}", (Object)string);
                }
                return Optional.ofNullable(module);
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOG.debug("Pomijam modu\u0142 {}", (Object)string);
                LOG.trace("Nie znaleziono klasy " + string, (Throwable)classNotFoundException);
                return Optional.empty();
            }
        }

        public List<Module> getInstances() {
            return new ArrayList<Module>(this.instances);
        }
    }
}

