/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.f;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.cert.X509Extension;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.asn1.bf;
import org.bouncycastle.asn1.f;
import org.bouncycastle.asn1.u.av;
import org.bouncycastle.asn1.u.aw;
import org.bouncycastle.f.c;
import org.bouncycastle.f.d;

public class e
implements X509Extension {
    org.bouncycastle.asn1.t.d awH;

    public e(org.bouncycastle.asn1.t.d d2) {
        this.awH = d2;
    }

    public e(byte[] byArray) {
        this(new ByteArrayInputStream(byArray));
    }

    public e(InputStream inputStream) {
        try {
            this.awH = org.bouncycastle.asn1.t.d.getInstance((Object)new f(inputStream).readObject());
        }
        catch (ClassCastException classCastException) {
            throw new IOException("malformed request: " + classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException("malformed request: " + illegalArgumentException);
        }
    }

    public int getVersion() {
        return this.awH.getVersion().getValue().intValue();
    }

    public String getMessageImprintAlgOID() {
        return this.awH.getMessageImprint().getHashAlgorithm().getObjectId().getId();
    }

    public byte[] getMessageImprintDigest() {
        return this.awH.getMessageImprint().getHashedMessage();
    }

    public String getReqPolicy() {
        if (this.awH.getReqPolicy() != null) {
            return this.awH.getReqPolicy().getId();
        }
        return null;
    }

    public BigInteger getNonce() {
        if (this.awH.getNonce() != null) {
            return this.awH.getNonce().getValue();
        }
        return null;
    }

    public boolean getCertReq() {
        if (this.awH.getCertReq() != null) {
            return this.awH.getCertReq().isTrue();
        }
        return false;
    }

    public void validate(Set set, Set set2, Set set3, String string) {
        int n;
        if (!set.contains(this.getMessageImprintAlgOID())) {
            throw new d("request contains unknown algorithm.", 128);
        }
        if (set2 != null && this.getReqPolicy() != null && !set2.contains(this.getReqPolicy())) {
            throw new d("request contains unknown policy.", 256);
        }
        if (this.getExtensions() != null && set3 != null) {
            Enumeration enumeration = this.getExtensions().oids();
            while (enumeration.hasMoreElements()) {
                String string2 = ((bf)enumeration.nextElement()).getId();
                if (set3.contains(string2)) continue;
                throw new d("request contains unknown extension.", 0x800000);
            }
        }
        if ((n = c.o(this.getMessageImprintAlgOID(), string)) != this.getMessageImprintDigest().length) {
            throw new d("imprint digest the wrong length.", 4);
        }
    }

    public byte[] getEncoded() {
        return this.awH.getEncoded();
    }

    aw getExtensions() {
        return this.awH.getExtensions();
    }

    @Override
    public byte[] getExtensionValue(String string) {
        av av2;
        aw aw2 = this.awH.getExtensions();
        if (aw2 != null && (av2 = aw2.getExtension(new bf(string))) != null) {
            try {
                return av2.getValue().getEncoded();
            }
            catch (Exception exception) {
                throw new RuntimeException("error encoding " + exception.toString());
            }
        }
        return null;
    }

    private Set t(boolean bl) {
        HashSet<String> hashSet = new HashSet<String>();
        aw aw2 = this.awH.getExtensions();
        if (aw2 != null) {
            Enumeration enumeration = aw2.oids();
            while (enumeration.hasMoreElements()) {
                bf bf2 = (bf)enumeration.nextElement();
                av av2 = aw2.getExtension(bf2);
                if (av2.isCritical() != bl) continue;
                hashSet.add(bf2.getId());
            }
            return hashSet;
        }
        return null;
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.t(false);
    }

    public Set getCriticalExtensionOIDs() {
        return this.t(true);
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        return false;
    }
}

