/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime.examples;

import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.a.as;
import org.bouncycastle.asn1.h;
import org.bouncycastle.asn1.u.aw;
import org.bouncycastle.b.a;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.mail.smime.b.a;
import org.bouncycastle.x509.a.c;

public class ValidateSignedMail {
    public static final boolean useCaCerts = false;
    public static final int TITLE = 0;
    public static final int TEXT = 1;
    public static final int SUMMARY = 2;
    public static final int DETAIL = 3;
    static int avP = 3;

    public static void main(String[] stringArray) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        Properties properties = System.getProperties();
        Session session = Session.getDefaultInstance((Properties)properties, null);
        MimeMessage mimeMessage = new MimeMessage(session, (InputStream)new FileInputStream("signed.message"));
        AbstractCollection abstractCollection = new HashSet<TrustAnchor>();
        Object object = ValidateSignedMail.getTrustAnchor("trustanchor");
        if (object == null) {
            System.out.println("no trustanchor file found, using a dummy trustanchor");
            object = ValidateSignedMail.fr();
        }
        abstractCollection.add(object);
        PKIXParameters pKIXParameters = new PKIXParameters((Set<TrustAnchor>)((Object)abstractCollection));
        abstractCollection = new ArrayList();
        object = ValidateSignedMail.loadCRL("crl.file");
        if (object != null) {
            abstractCollection.add((Object)object);
        }
        CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(abstractCollection), "BC");
        pKIXParameters.addCertStore(certStore);
        pKIXParameters.setRevocationEnabled(true);
        ValidateSignedMail.verifySignedMail(mimeMessage, pKIXParameters);
    }

    public static void verifySignedMail(MimeMessage mimeMessage, PKIXParameters pKIXParameters) {
        Locale locale = Locale.ENGLISH;
        org.bouncycastle.mail.smime.b.a a2 = new org.bouncycastle.mail.smime.b.a(mimeMessage, pKIXParameters);
        for (as as2 : a2.getSignerInformationStore().getSigners()) {
            Object object;
            Object object22;
            Object object3;
            a.a a3 = a2.getValidationResult(as2);
            if (a3.isValidSignature()) {
                object3 = new a("org.bouncycastle.mail.smime.validator.SignedMailValidatorMessages", "SignedMailValidator.sigValid");
                System.out.println(object3.getText(locale));
            } else {
                object3 = new a("org.bouncycastle.mail.smime.validator.SignedMailValidatorMessages", "SignedMailValidator.sigInvalid");
                System.out.println(object3.getText(locale));
                System.out.println("Errors:");
                for (Object object22 : a3.getErrors()) {
                    if (avP == 3) {
                        System.out.println("\t\t" + object22.getDetail(locale));
                        continue;
                    }
                    System.out.println("\t\t" + object22.getText(locale));
                }
            }
            if (!a3.getNotifications().isEmpty()) {
                System.out.println("Notifications:");
                object3 = a3.getNotifications().iterator();
                while (object3.hasNext()) {
                    a a4 = (a)object3.next();
                    if (avP == 3) {
                        System.out.println("\t\t" + a4.getDetail(locale));
                        continue;
                    }
                    System.out.println("\t\t" + a4.getText(locale));
                }
            }
            if ((object3 = a3.getCertPathReview()) == null) continue;
            if (object3.isValidCertPath()) {
                System.out.println("Certificate path valid");
            } else {
                System.out.println("Certificate path invalid");
            }
            System.out.println("\nCertificate path validation results:");
            System.out.println("Errors:");
            for (Object object22 : object3.getErrors(-1)) {
                if (avP == 3) {
                    System.out.println("\t\t" + object22.getDetail(locale));
                    continue;
                }
                System.out.println("\t\t" + object22.getText(locale));
            }
            System.out.println("Notifications:");
            object22 = object3.getNotifications(-1).iterator();
            while (object22.hasNext()) {
                object = (a)object22.next();
                System.out.println("\t" + object.getText(locale));
            }
            object = object3.getCertPath().getCertificates().iterator();
            int n2 = 0;
            while (object.hasNext()) {
                X509Certificate x509Certificate = (X509Certificate)object.next();
                System.out.println("\nCertificate " + n2 + "\n========");
                System.out.println("Issuer: " + x509Certificate.getIssuerDN().getName());
                System.out.println("Subject: " + x509Certificate.getSubjectDN().getName());
                System.out.println("\tErrors:");
                for (a a5 : object3.getErrors(n2)) {
                    if (avP == 3) {
                        System.out.println("\t\t" + a5.getDetail(locale));
                        continue;
                    }
                    System.out.println("\t\t" + a5.getText(locale));
                }
                System.out.println("\tNotifications:");
                object22 = object3.getNotifications(n2).iterator();
                while (object22.hasNext()) {
                    a a5;
                    a5 = (a)object22.next();
                    if (avP == 3) {
                        System.out.println("\t\t" + a5.getDetail(locale));
                        continue;
                    }
                    System.out.println("\t\t" + a5.getText(locale));
                }
                ++n2;
            }
        }
    }

    protected static TrustAnchor getTrustAnchor(String string) {
        X509Certificate x509Certificate = ValidateSignedMail.loadCert(string);
        if (x509Certificate != null) {
            byte[] byArray = x509Certificate.getExtensionValue(aw.NameConstraints.getId());
            if (byArray != null) {
                h h2 = c.fromExtensionValue((byte[])byArray);
                return new TrustAnchor(x509Certificate, h2.getDEREncoded());
            }
            return new TrustAnchor(x509Certificate, null);
        }
        return null;
    }

    protected static X509Certificate loadCert(String string) {
        X509Certificate x509Certificate = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
            x509Certificate = (X509Certificate)certificateFactory.generateCertificate(fileInputStream);
        }
        catch (Exception exception) {
            System.out.println("certfile \"" + string + "\" not found - classpath is " + System.getProperty("java.class.path"));
        }
        return x509Certificate;
    }

    protected static X509CRL loadCRL(String string) {
        X509CRL x509CRL = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
            x509CRL = (X509CRL)certificateFactory.generateCRL(fileInputStream);
        }
        catch (Exception exception) {
            System.out.println("crlfile \"" + string + "\" not found - classpath is " + System.getProperty("java.class.path"));
        }
        return x509CRL;
    }

    private static TrustAnchor fr() {
        X500Principal x500Principal = new X500Principal("CN=Dummy Trust Anchor");
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
        keyPairGenerator.initialize(1024, new SecureRandom());
        PublicKey publicKey = keyPairGenerator.generateKeyPair().getPublic();
        return new TrustAnchor(x500Principal, publicKey, null);
    }
}

