/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime.examples;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.bouncycastle.asn1.ar;
import org.bouncycastle.asn1.as;
import org.bouncycastle.asn1.c.m;
import org.bouncycastle.asn1.r.b;
import org.bouncycastle.asn1.r.c;
import org.bouncycastle.asn1.r.d;
import org.bouncycastle.asn1.r.e;
import org.bouncycastle.asn1.u.ay;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.mail.smime.f;
import org.bouncycastle.mail.smime.h;
import org.bouncycastle.mail.smime.k;
import org.bouncycastle.util.i;

public class SendSignedAndEncryptedMail {
    public static void main(String[] stringArray) {
        if (stringArray.length != 5) {
            System.err.println("usage: SendSignedAndEncryptedMail <pkcs12Keystore> <password> <keyalias> <smtp server> <email address>");
            System.exit(0);
        }
        try {
            MailcapCommandMap mailcapCommandMap = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
            mailcapCommandMap.addMailcap("application/pkcs7-signature;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_signature");
            mailcapCommandMap.addMailcap("application/pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_mime");
            mailcapCommandMap.addMailcap("application/x-pkcs7-signature;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_signature");
            mailcapCommandMap.addMailcap("application/x-pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_mime");
            mailcapCommandMap.addMailcap("multipart/signed;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.multipart_signed");
            CommandMap.setDefaultCommandMap((CommandMap)mailcapCommandMap);
            Security.addProvider((Provider)new BouncyCastleProvider());
            KeyStore keyStore = KeyStore.getInstance("PKCS12", "BC");
            keyStore.load(new FileInputStream(stringArray[0]), stringArray[1].toCharArray());
            Certificate[] certificateArray = keyStore.getCertificateChain(stringArray[2]);
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(stringArray[2], stringArray[1].toCharArray());
            if (privateKey == null) {
                throw new Exception("cannot find private key for alias: " + stringArray[2]);
            }
            Properties properties = System.getProperties();
            properties.put("mail.smtp.host", stringArray[3]);
            Session session = Session.getDefaultInstance((Properties)properties, null);
            MimeMessage mimeMessage = new MimeMessage(session);
            mimeMessage.setFrom((Address)new InternetAddress(stringArray[4]));
            mimeMessage.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(stringArray[4]));
            mimeMessage.setSubject("example encrypted message");
            mimeMessage.setContent((Object)"example encrypted message", "text/plain");
            mimeMessage.saveChanges();
            d d2 = new d();
            d2.addCapability(c.dES_EDE3_CBC);
            d2.addCapability(c.rC2_CBC, 128);
            d2.addCapability(c.dES_CBC);
            org.bouncycastle.asn1.d d3 = new org.bouncycastle.asn1.d();
            d3.add((ar)new e(new m(new ay(((X509Certificate)certificateArray[0]).getIssuerDN().getName()), ((X509Certificate)certificateArray[0]).getSerialNumber())));
            d3.add((ar)new b(d2));
            k k2 = new k();
            k2.addSigner(privateKey, (X509Certificate)certificateArray[0], "DSA".equals(privateKey.getAlgorithm()) ? k.DIGEST_SHA1 : k.DIGEST_MD5, new org.bouncycastle.asn1.c.b((as)d3), null);
            ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
            arrayList.add(certificateArray[0]);
            CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(arrayList), "BC");
            k2.addCertificatesAndCRLs(certStore);
            MimeMultipart mimeMultipart = k2.generate(mimeMessage, "BC");
            MimeMessage mimeMessage2 = new MimeMessage(session);
            Enumeration enumeration = mimeMessage.getAllHeaderLines();
            while (enumeration.hasMoreElements()) {
                mimeMessage2.addHeaderLine((String)enumeration.nextElement());
            }
            mimeMessage2.setContent((Multipart)mimeMultipart);
            mimeMessage2.saveChanges();
            f f2 = new f();
            f2.addKeyTransRecipient((X509Certificate)certificateArray[0]);
            MimeBodyPart mimeBodyPart = f2.generate(mimeMessage2, f.RC2_CBC, "BC");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            mimeBodyPart.writeTo((OutputStream)byteArrayOutputStream);
            MimeMessage mimeMessage3 = new MimeMessage(session, (InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            enumeration = mimeMessage.getAllHeaderLines();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (i.toLowerCase((String)string).startsWith("content-")) continue;
                mimeMessage3.addHeaderLine(string);
            }
            Transport.send((Message)mimeMessage3);
        }
        catch (h h2) {
            h2.getUnderlyingException().printStackTrace(System.err);
            h2.printStackTrace(System.err);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

