/*
 * Decompiled with CFR 0.152.
 */
package pl.unizeto.x509.extensions.qualified.structures;

import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.PrintableString;
import iaik.asn1.SEQUENCE;
import iaik.x509.extensions.qualified.structures.QCStatement;
import iaik.x509.extensions.qualified.structures.QCStatementInfo;
import java.math.BigInteger;

public class c
extends QCStatementInfo {
    public static final ObjectID statementID = new ObjectID("0.4.0.1862.1.2", "TransactionLimitQCStatement");
    public static final String CURRENCY_CODE_PLN = "PLN";
    private String cuG = "PLN";
    private BigInteger cuH = new BigInteger("0");
    private BigInteger atO = new BigInteger("0");

    public c() {
        QCStatement.register((ObjectID)statementID, c.class);
    }

    public c(String string, BigInteger bigInteger, BigInteger bigInteger2) {
        this();
        if (string == null || string.length() != 3) {
            throw new IllegalArgumentException("invalid currencyCodeAlphabetic");
        }
        if (bigInteger == null || bigInteger.compareTo(BigInteger.ZERO) == -1) {
            throw new IllegalArgumentException("invalid amount");
        }
        if (bigInteger2 == null) {
            throw new IllegalArgumentException("invalid exponent");
        }
        this.cuG = string;
        this.cuH = bigInteger;
        this.atO = bigInteger2;
    }

    public ObjectID getStatementID() {
        return statementID;
    }

    public void decode(ASN1Object aSN1Object) {
        if (!(aSN1Object.getComponentAt(0) instanceof PrintableString)) {
            StringBuffer stringBuffer = new StringBuffer("B??d dekodowania sktuktury MonetaryValue");
            stringBuffer.append(" Brak pola currency w spodziewanym miejscu.");
            throw new CodingException(stringBuffer.toString());
        }
        this.cuG = (String)aSN1Object.getComponentAt(0).getValue();
        try {
            if (!(aSN1Object.getComponentAt(1) instanceof INTEGER)) {
                StringBuffer stringBuffer = new StringBuffer("B??d dekodowania sktuktury MonetaryValue.");
                stringBuffer.append(" Brak pola amount w spodziewanym miejscu.");
                throw new CodingException(stringBuffer.toString());
            }
            this.cuH = (BigInteger)((INTEGER)aSN1Object.getComponentAt(1)).getValue();
            if (!(aSN1Object.getComponentAt(2) instanceof INTEGER)) {
                StringBuffer stringBuffer = new StringBuffer("B??d dekodowania sktuktury MonetaryValue.");
                stringBuffer.append(" Brak pola exponent w spodziewanym miejscu.");
                throw new CodingException(stringBuffer.toString());
            }
            this.atO = (BigInteger)((INTEGER)aSN1Object.getComponentAt(2)).getValue();
        }
        catch (Exception exception) {
            throw new CodingException("B??d parsowanie struktury MonetaryValue.");
        }
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent((ASN1Object)new PrintableString(this.cuG));
        sEQUENCE.addComponent((ASN1Object)new INTEGER(this.cuH));
        sEQUENCE.addComponent((ASN1Object)new INTEGER(this.atO));
        return sEQUENCE;
    }

    public void setCurrencyCode(String string) {
        if (string == null || string.length() != 3) {
            throw new IllegalArgumentException("invalid currencyCodeAlphabetic");
        }
        this.cuG = string;
    }

    public String getCurrencyCode() {
        return this.cuG;
    }

    public void setAmount(BigInteger bigInteger) {
        if (bigInteger == null || bigInteger.compareTo(BigInteger.ZERO) == -1) {
            throw new IllegalArgumentException("invalid amount");
        }
        this.cuH = bigInteger;
    }

    public BigInteger getAmount() {
        return this.cuH;
    }

    public void setExponent(BigInteger bigInteger) {
        if (bigInteger == null) {
            throw new IllegalArgumentException("invalid exponent");
        }
        this.atO = bigInteger;
    }

    public BigInteger getExponent() {
        return this.atO;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\ncurrencyCode: ");
        stringBuffer.append(this.cuG);
        stringBuffer.append("\namount: ");
        stringBuffer.append(this.cuH.toString());
        stringBuffer.append("\nexponent: ");
        stringBuffer.append(this.atO.toString());
        return stringBuffer.toString();
    }
}

