/*
 * Decompiled with CFR 0.152.
 */
package pl.unizeto.x509.extensions.qualified.structures;

import iaik.asn1.ASN1Object;
import iaik.asn1.BMPString;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.GeneralizedTime;
import iaik.asn1.IA5String;
import iaik.asn1.ObjectID;
import iaik.asn1.PrintableString;
import iaik.asn1.SEQUENCE;
import iaik.asn1.T61String;
import iaik.asn1.UNIString;
import iaik.asn1.UTF8String;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.GeneralName;
import iaik.x509.extensions.SubjectDirectoryAttributes;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

public class SubjectDirectoryAttributesExtension {
    private SubjectDirectoryAttributes cun;
    private String cuo;
    private String cup;
    private String cuq;
    private String cur;
    private Date cus;
    private String title;
    private String cut;
    private ArrayList cuu;
    private String cuv;
    private ArrayList cuw;
    private String cux;
    private ArrayList cuy;
    private String cuz;
    private ArrayList cuA;
    private ArrayList cuB;
    private String cuC;
    private ArrayList cuD;
    private String cuE;
    private boolean critical = false;

    public SubjectDirectoryAttributesExtension() {
    }

    public SubjectDirectoryAttributesExtension(SubjectDirectoryAttributes subjectDirectoryAttributes) {
        this.cun = subjectDirectoryAttributes;
        this.decode();
    }

    public SubjectDirectoryAttributes getSubjectDirectoryAttributes() {
        this.to();
        return this.cun;
    }

    public void setCritical(boolean bl) {
        this.critical = bl;
    }

    public boolean isCritical() {
        return this.critical;
    }

    public String getGender() {
        return this.cuo;
    }

    public void setGender(String string) {
        this.cuo = string;
    }

    public String getGender_asn1Type() {
        return this.cup;
    }

    public void setGender_asn1Type(String string) {
        this.cup = string;
    }

    public Date getDateOfBirth() {
        return this.cus;
    }

    public void setDateOfBirth(Date date) {
        this.cus = date;
    }

    public String getPlaceOfBirth() {
        return this.cuq;
    }

    public void setPlaceOfBirth(String string) {
        this.cuq = string;
    }

    public String getPlaceOfBirth_asn1Type() {
        return this.cur;
    }

    public void setPlaceOfBirth_asn1Type(String string) {
        this.cur = string;
    }

    public String getCountryOfCitizenship() {
        if (this.cuw == null) {
            return null;
        }
        return (String)this.cuw.get(0);
    }

    public String[] getCountryOfCitizenships() {
        if (this.cuw == null) {
            return null;
        }
        String[] stringArray = new String[this.cuw.size()];
        this.cuw.toArray(stringArray);
        return stringArray;
    }

    public void setCountryOfCitizenship(String string) {
        if (this.cuw == null) {
            this.cuw = new ArrayList();
        }
        this.cuw.add(string);
    }

    public String getCountryOfCitizenship_asn1Type() {
        return this.cux;
    }

    public void setCountryOfCitizenship_asn1Type(String string) {
        this.cux = string;
    }

    public void setCountryOfCitizenships(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        this.cuw = new ArrayList();
        for (int j = 0; j < stringArray.length; ++j) {
            this.cuw.add(stringArray[j]);
        }
    }

    public String getCountryOfResidence() {
        if (this.cuu == null) {
            return null;
        }
        return (String)this.cuu.get(0);
    }

    public String[] getCountryOfResidences() {
        if (this.cuu == null) {
            return null;
        }
        String[] stringArray = new String[this.cuu.size()];
        this.cuu.toArray(stringArray);
        return stringArray;
    }

    public void setCountryOfResidence(String string) {
        if (this.cuu == null) {
            this.cuu = new ArrayList();
        }
        this.cuu.add(string);
    }

    public String getCountryOfResidence_asn1Type() {
        return this.cuv;
    }

    public void setCountryOfResidence_asn1Type(String string) {
        this.cuv = string;
    }

    public void setCountryOfResidences(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        this.cuu = new ArrayList();
        for (int j = 0; j < stringArray.length; ++j) {
            this.cuu.add(stringArray[j]);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getTitle_asn1Type() {
        return this.cut;
    }

    public void setTitle_asn1Type(String string) {
        this.cut = string;
    }

    public String getRole() {
        if (this.cuA == null) {
            return null;
        }
        return (String)this.cuA.get(0);
    }

    public String[] getRoles() {
        if (this.cuA == null) {
            return null;
        }
        String[] stringArray = new String[this.cuA.size()];
        this.cuA.toArray(stringArray);
        return stringArray;
    }

    public void setRole(String string) {
        if (this.cuA == null) {
            this.cuA = new ArrayList();
        }
        this.cuA.add(string);
    }

    public void setRoles(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        this.cuA = new ArrayList();
        for (int j = 0; j < stringArray.length; ++j) {
            this.cuA.add(stringArray[j]);
        }
    }

    public String getEmail() {
        if (this.cuy == null) {
            return null;
        }
        return (String)this.cuy.get(0);
    }

    public String[] getEmails() {
        if (this.cuy == null) {
            return null;
        }
        String[] stringArray = new String[this.cuy.size()];
        this.cuy.toArray(stringArray);
        return stringArray;
    }

    public void setEmail(String string) {
        if (this.cuy == null) {
            this.cuy = new ArrayList();
        }
        this.cuy.add(string);
    }

    public String getEmail_asn1Type() {
        return this.cuz;
    }

    public void setEmail_asn1Type(String string) {
        this.cuz = string;
    }

    public void setEmails(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        this.cuy = new ArrayList();
        for (int j = 0; j < stringArray.length; ++j) {
            this.cuy.add(stringArray[j]);
        }
    }

    public String getTelephone() {
        if (this.cuB == null) {
            return null;
        }
        return (String)this.cuB.get(0);
    }

    public String[] getTelephones() {
        if (this.cuB == null) {
            return null;
        }
        String[] stringArray = new String[this.cuB.size()];
        this.cuB.toArray(stringArray);
        return stringArray;
    }

    public void setTelephone(String string) {
        if (this.cuB == null) {
            this.cuB = new ArrayList();
        }
        this.cuB.add(string);
    }

    public String getTelephone_asn1Type() {
        return this.cuC;
    }

    public void setTelephone_asn1Type(String string) {
        this.cuC = string;
    }

    public void setTelephones(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        this.cuB = new ArrayList();
        for (int j = 0; j < stringArray.length; ++j) {
            this.cuB.add(stringArray[j]);
        }
    }

    public String getFax() {
        if (this.cuD == null) {
            return null;
        }
        return (String)this.cuD.get(0);
    }

    public String[] getFaxs() {
        if (this.cuD == null) {
            return null;
        }
        String[] stringArray = new String[this.cuD.size()];
        this.cuD.toArray(stringArray);
        return stringArray;
    }

    public void setFax(String string) {
        if (this.cuD == null) {
            this.cuD = new ArrayList();
        }
        this.cuD.add(string);
    }

    public String getFax_asn1Type() {
        return this.cuE;
    }

    public void setFax_asn1Type(String string) {
        this.cuE = string;
    }

    public void setFaxs(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        this.cuD = new ArrayList();
        for (int j = 0; j < stringArray.length; ++j) {
            this.cuD.add(stringArray[j]);
        }
    }

    public ASN1Object toASN1Object() {
        try {
            this.to();
            return this.cun.toASN1Object();
        }
        catch (Exception exception) {
            throw new CodingException();
        }
    }

    public void decode() {
        if (this.cun == null) {
            return;
        }
        this.critical = this.cun.isCritical();
        Attribute[] attributeArray = this.cun.getAttributes();
        for (int j = 0; j < attributeArray.length; ++j) {
            Calendar calendar;
            String string;
            ASN1Object[] aSN1ObjectArray;
            if (attributeArray[j].getType().equals((Object)ObjectID.gender)) {
                aSN1ObjectArray = attributeArray[j].getValue();
                this.cuo = (String)aSN1ObjectArray[0].getValue();
                this.cup = this.h(aSN1ObjectArray[0]);
            }
            if (attributeArray[j].getType().equals((Object)ObjectID.dateOfBirth)) {
                aSN1ObjectArray = attributeArray[j].getValue();
                string = (String)aSN1ObjectArray[0].getValue();
                calendar = Calendar.getInstance();
                calendar.set(1, Integer.parseInt(string.substring(0, 4)));
                calendar.set(2, Integer.parseInt(string.substring(4, 6)) - 1);
                calendar.set(5, Integer.parseInt(string.substring(6, 8)));
                calendar.set(11, Integer.parseInt(string.substring(8, 10)));
                calendar.set(12, Integer.parseInt(string.substring(10, 12)));
                calendar.set(13, Integer.parseInt(string.substring(12, 14)));
                int n = -1;
                n = string.lastIndexOf(46);
                if (n != -1) {
                    calendar.set(14, Integer.parseInt(string.substring(n + 1, string.length() - 1)));
                }
                this.cus = calendar.getTime();
            }
            if (attributeArray[j].getType().equals((Object)ObjectID.placeOfBirth)) {
                aSN1ObjectArray = attributeArray[j].getValue();
                this.cuq = (String)aSN1ObjectArray[0].getValue();
                this.cur = this.h(aSN1ObjectArray[0]);
            }
            if (attributeArray[j].getType().equals((Object)ObjectID.countryOfCitizenship)) {
                aSN1ObjectArray = attributeArray[j].getValue();
                this.setCountryOfCitizenship((String)aSN1ObjectArray[0].getValue());
                this.cux = this.h(aSN1ObjectArray[0]);
            }
            if (attributeArray[j].getType().equals((Object)ObjectID.countryOfResidence)) {
                aSN1ObjectArray = attributeArray[j].getValue();
                this.setCountryOfResidence((String)aSN1ObjectArray[0].getValue());
                this.cuv = this.h(aSN1ObjectArray[0]);
            }
            if (attributeArray[j].getType().equals((Object)ObjectID.title)) {
                aSN1ObjectArray = attributeArray[j].getValue();
                this.title = (String)aSN1ObjectArray[0].getValue();
                this.cut = this.h(aSN1ObjectArray[0]);
            }
            if (attributeArray[j].getType().equals((Object)new ObjectID("2.5.4.72"))) {
                aSN1ObjectArray = attributeArray[j].getValue();
                string = (SEQUENCE)aSN1ObjectArray[0];
                calendar = (CON_SPEC)string.getComponentAt(0);
                GeneralName generalName = new GeneralName((ASN1Object)calendar.getValue());
                this.setRole((String)generalName.getName());
            }
            if (attributeArray[j].getType().equals((Object)ObjectID.emailAddress)) {
                aSN1ObjectArray = attributeArray[j].getValue();
                this.setEmail((String)aSN1ObjectArray[0].getValue());
                this.cuz = this.h(aSN1ObjectArray[0]);
            }
            if (attributeArray[j].getType().equals((Object)new ObjectID("2.5.4.20"))) {
                aSN1ObjectArray = attributeArray[j].getValue();
                this.setTelephone((String)aSN1ObjectArray[0].getValue());
                this.cuC = this.h(aSN1ObjectArray[0]);
            }
            if (!attributeArray[j].getType().equals((Object)new ObjectID("2.5.4.23"))) continue;
            aSN1ObjectArray = attributeArray[j].getValue();
            this.setFax((String)aSN1ObjectArray[0].getValue());
            this.cuE = this.h(aSN1ObjectArray[0]);
        }
    }

    private void to() {
        DecimalFormat decimalFormat;
        DecimalFormat decimalFormat2;
        Calendar calendar;
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        if (this.cuo != null && !this.cuo.trim().equals("")) {
            calendar = this.K(this.cup, this.cuo);
            arrayList.add(new Attribute(ObjectID.gender, new ASN1Object[]{calendar}));
        }
        if (this.cus != null) {
            calendar = Calendar.getInstance();
            calendar.setTime(this.cus);
            decimalFormat2 = new DecimalFormat("0000");
            decimalFormat = new DecimalFormat("00");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(decimalFormat2.format(calendar.get(1)));
            stringBuffer.append(decimalFormat.format(calendar.get(2) + 1));
            stringBuffer.append(decimalFormat.format(calendar.get(5)));
            stringBuffer.append(decimalFormat.format(calendar.get(11)));
            stringBuffer.append(decimalFormat.format(calendar.get(12)));
            stringBuffer.append(decimalFormat.format(calendar.get(13)));
            stringBuffer.append('Z');
            GeneralizedTime generalizedTime = new GeneralizedTime(stringBuffer.toString());
            arrayList.add(new Attribute(ObjectID.dateOfBirth, new ASN1Object[]{generalizedTime}));
        }
        if (this.cuq != null && !this.cuq.trim().equals("")) {
            calendar = this.K(this.cur, this.cuq);
            arrayList.add(new Attribute(ObjectID.placeOfBirth, new ASN1Object[]{calendar}));
        }
        if (this.cuw != null && this.cuw.size() > 0) {
            for (int j = 0; j < this.cuw.size(); ++j) {
                decimalFormat2 = this.K(this.cux, (String)this.cuw.get(j));
                arrayList.add(new Attribute(ObjectID.countryOfCitizenship, new ASN1Object[]{decimalFormat2}));
            }
        }
        if (this.cuu != null && this.cuu.size() > 0) {
            for (int j = 0; j < this.cuu.size(); ++j) {
                decimalFormat2 = this.K(this.cuv, (String)this.cuu.get(j));
                arrayList.add(new Attribute(ObjectID.countryOfResidence, new ASN1Object[]{decimalFormat2}));
            }
        }
        if (this.title != null && !this.title.trim().equals("")) {
            ASN1Object aSN1Object = this.K(this.cut, this.title);
            arrayList.add(new Attribute(ObjectID.title, new ASN1Object[]{aSN1Object}));
        }
        if (this.cuA != null && this.cuA.size() > 0) {
            try {
                for (int j = 0; j < this.cuA.size(); ++j) {
                    decimalFormat2 = new SEQUENCE();
                    decimalFormat = new GeneralName(6, (Object)((String)this.cuA.get(j)));
                    decimalFormat2.addComponent((ASN1Object)new CON_SPEC(1, decimalFormat.toASN1Object()));
                    arrayList.add(new Attribute(new ObjectID("2.5.4.72"), new ASN1Object[]{decimalFormat2}));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.cuy != null && this.cuy.size() > 0) {
            for (int j = 0; j < this.cuy.size(); ++j) {
                decimalFormat2 = this.K(this.cuz, (String)this.cuy.get(j));
                arrayList.add(new Attribute(ObjectID.emailAddress, new ASN1Object[]{decimalFormat2}));
            }
        }
        if (this.cuB != null && this.cuB.size() > 0) {
            for (int j = 0; j < this.cuB.size(); ++j) {
                decimalFormat2 = this.K(this.cuC, (String)this.cuB.get(j));
                arrayList.add(new Attribute(new ObjectID("2.5.4.20"), new ASN1Object[]{decimalFormat2}));
            }
        }
        if (this.cuD != null && this.cuD.size() > 0) {
            for (int j = 0; j < this.cuD.size(); ++j) {
                decimalFormat2 = this.K(this.cuE, (String)this.cuD.get(j));
                arrayList.add(new Attribute(new ObjectID("2.5.4.23"), new ASN1Object[]{decimalFormat2}));
            }
        }
        if (arrayList.size() > 0) {
            Attribute[] attributeArray = new Attribute[arrayList.size()];
            for (int j = 0; j < attributeArray.length; ++j) {
                attributeArray[j] = (Attribute)arrayList.get(j);
            }
            this.cun = new SubjectDirectoryAttributes(attributeArray);
            this.cun.setCritical(this.critical);
        }
    }

    public String toString() {
        this.to();
        return this.cun.toString();
    }

    private ASN1Object K(String string, String string2) {
        Object object = string == null ? new PrintableString(string2) : (string.equalsIgnoreCase("printableString") ? new PrintableString(string2) : (string.equalsIgnoreCase("teletextString") ? new T61String(string2) : (string.equalsIgnoreCase("universalString") ? new UNIString(string2) : (string.equalsIgnoreCase("utf8String") ? new UTF8String(string2) : (string.equalsIgnoreCase("bmpString") ? new BMPString(string2) : (string.equalsIgnoreCase("ia5String") ? new IA5String(string2) : new PrintableString(string2)))))));
        return object;
    }

    private String h(ASN1Object aSN1Object) {
        String string = "printableString";
        string = aSN1Object instanceof PrintableString ? "printableString" : (aSN1Object instanceof T61String ? "teletextString" : (aSN1Object instanceof UNIString ? "universalString" : (aSN1Object instanceof UTF8String ? "utf8String" : (aSN1Object instanceof BMPString ? "bmpString" : (aSN1Object instanceof IA5String ? "ia5String" : "printableString")))));
        return string;
    }

    public static void main(String[] stringArray) {
        try {
            SubjectDirectoryAttributesExtension subjectDirectoryAttributesExtension = new SubjectDirectoryAttributesExtension(null);
            subjectDirectoryAttributesExtension.setGender("F");
            subjectDirectoryAttributesExtension.setDateOfBirth(new Date());
            subjectDirectoryAttributesExtension.setPlaceOfBirth("Koluszki");
            subjectDirectoryAttributesExtension.setCountryOfCitizenships(new String[]{"PL", "DE"});
            subjectDirectoryAttributesExtension.setCountryOfResidences(new String[]{"PL", "US"});
            subjectDirectoryAttributesExtension.setTitle("Dyrektor generalny");
            subjectDirectoryAttributesExtension.setRoles(new String[]{"Prokurator generalny", "Prokurator generalny2"});
            subjectDirectoryAttributesExtension.setEmails(new String[]{"swojcik@unizeto.pl", "s9wojcik@wp.pl"});
            subjectDirectoryAttributesExtension.getSubjectDirectoryAttributes();
            subjectDirectoryAttributesExtension.decode();
            System.out.println(subjectDirectoryAttributesExtension.toString());
            System.out.println("*** KONIEC ***");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

