/*
 * Decompiled with CFR 0.152.
 */
package pl.unizeto.x509.extensions.qualified.structures;

import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.UTF8String;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.GeneralNames;
import iaik.x509.extensions.SubjectAltName;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Enumeration;

public class SubjectAlternativeNameExtension {
    private SubjectAltName cuf;
    private ArrayList cug;
    private ArrayList cuh;
    private ArrayList cui;
    private ArrayList cuj;
    private ArrayList cuk;
    private ObjectID cul = new ObjectID("1.3.6.1.4.1.311.25.1");
    private ObjectID cum = new ObjectID("1.3.6.1.4.1.311.20.2.3");
    private boolean critical = false;

    public SubjectAlternativeNameExtension() {
    }

    public SubjectAlternativeNameExtension(SubjectAltName subjectAltName) {
        this.cuf = subjectAltName;
        this.decode();
    }

    public void setCritical(boolean bl) {
        this.critical = bl;
    }

    public String getEmail() {
        if (this.cug == null) {
            return null;
        }
        return (String)this.cug.get(0);
    }

    public String[] getEmails() {
        if (this.cug == null) {
            return null;
        }
        String[] stringArray = new String[this.cug.size()];
        this.cug.toArray(stringArray);
        return stringArray;
    }

    public void setEmail(String string) {
        if (this.cug == null) {
            this.cug = new ArrayList();
        }
        this.cug.add(string);
    }

    public String getDns() {
        if (this.cuh == null) {
            return null;
        }
        return (String)this.cuh.get(0);
    }

    public String[] getDnss() {
        if (this.cuh == null) {
            return null;
        }
        String[] stringArray = new String[this.cuh.size()];
        this.cuh.toArray(stringArray);
        return stringArray;
    }

    public void setDns(String string) {
        if (this.cuh == null) {
            this.cuh = new ArrayList();
        }
        this.cuh.add(string);
    }

    public String getUri() {
        if (this.cui == null) {
            return null;
        }
        return (String)this.cui.get(0);
    }

    public String[] getUris() {
        if (this.cui == null) {
            return null;
        }
        String[] stringArray = new String[this.cui.size()];
        this.cui.toArray(stringArray);
        return stringArray;
    }

    public void setUri(String string) {
        if (this.cui == null) {
            this.cui = new ArrayList();
        }
        this.cui.add(string);
    }

    public String getGuid() {
        if (this.cuj == null) {
            return null;
        }
        return (String)this.cuj.get(0);
    }

    public String[] getGuids() {
        if (this.cuj == null) {
            return null;
        }
        String[] stringArray = new String[this.cuj.size()];
        this.cuj.toArray(stringArray);
        return stringArray;
    }

    public void setGuid(String string) {
        if (this.cuj == null) {
            this.cuj = new ArrayList();
        }
        this.cuj.add(string);
    }

    public ObjectID getGuidOid() {
        return this.cul;
    }

    public void setGuidOid(ObjectID objectID) {
        this.cul = objectID;
    }

    public String getUpn() {
        if (this.cuk == null) {
            return null;
        }
        return (String)this.cuk.get(0);
    }

    public String[] getUpns() {
        if (this.cuk == null) {
            return null;
        }
        String[] stringArray = new String[this.cuk.size()];
        this.cuk.toArray(stringArray);
        return stringArray;
    }

    public void setUpn(String string) {
        if (this.cuk == null) {
            this.cuk = new ArrayList();
        }
        this.cuk.add(string);
    }

    public ObjectID getUpnOid() {
        return this.cum;
    }

    public void setUpnOid(ObjectID objectID) {
        this.cum = objectID;
    }

    public void decode() {
        if (this.cuf == null) {
            return;
        }
        this.critical = this.cuf.isCritical();
        GeneralNames generalNames = this.cuf.getGeneralNames();
        Enumeration enumeration = generalNames.getNames();
        if (enumeration == null) {
            return;
        }
        while (enumeration.hasMoreElements()) {
            GeneralName generalName = (GeneralName)enumeration.nextElement();
            switch (generalName.getType()) {
                case 1: {
                    this.setEmail((String)generalName.getName());
                    break;
                }
                case 2: {
                    this.setDns((String)generalName.getName());
                    break;
                }
                case 6: {
                    this.setUri((String)generalName.getName());
                    break;
                }
                case 0: {
                    this.a(generalName);
                }
            }
        }
    }

    private void a(GeneralName generalName) {
        block6: {
            SEQUENCE sEQUENCE = (SEQUENCE)generalName.getName();
            ObjectID objectID = (ObjectID)sEQUENCE.getComponentAt(0);
            CON_SPEC cON_SPEC = (CON_SPEC)sEQUENCE.getComponentAt(1);
            if (objectID == null || cON_SPEC == null) {
                return;
            }
            try {
                if (objectID.equals((Object)this.cul)) {
                    OCTET_STRING oCTET_STRING = (OCTET_STRING)cON_SPEC.getValue();
                    byte[] byArray = oCTET_STRING.getWholeValue();
                    String string = "";
                    for (int j = 0; j < byArray.length; ++j) {
                        byte by = (byte)(byArray[j] >> 4 & 0xF);
                        byte by2 = (byte)(byArray[j] & 0xF);
                        by = by < 10 ? (byte)(by + 48) : (byte)(by + 65 - 10);
                        by2 = by2 < 10 ? (byte)(by2 + 48) : (byte)(by2 + 65 - 10);
                        string = string + new String(new byte[]{by, by2});
                    }
                    System.out.println(string);
                    this.setGuid(string);
                    break block6;
                }
                if (objectID.equals((Object)this.cum)) {
                    UTF8String uTF8String = (UTF8String)cON_SPEC.getValue();
                    this.setUpn((String)uTF8String.getValue());
                    break block6;
                }
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
    }

    public SubjectAltName getSubjectAltName() {
        this.tn();
        return this.cuf;
    }

    public ASN1Object toASN1Object() {
        try {
            this.tn();
            return this.cuf.toASN1Object();
        }
        catch (Exception exception) {
            throw new CodingException();
        }
    }

    private void tn() {
        SEQUENCE sEQUENCE;
        Object object;
        String string;
        int n;
        ArrayList<GeneralName> arrayList = new ArrayList<GeneralName>();
        GeneralName generalName = null;
        if (this.cug != null && this.cug.size() > 0) {
            for (n = 0; n < this.cug.size(); ++n) {
                string = (String)this.cug.get(n);
                generalName = new GeneralName(1, (Object)string);
                arrayList.add(generalName);
            }
        }
        if (this.cuh != null && this.cuh.size() > 0) {
            for (n = 0; n < this.cuh.size(); ++n) {
                string = (String)this.cuh.get(n);
                generalName = new GeneralName(2, (Object)string);
                arrayList.add(generalName);
            }
        }
        if (this.cui != null && this.cui.size() > 0) {
            for (n = 0; n < this.cui.size(); ++n) {
                string = (String)this.cui.get(n);
                generalName = new GeneralName(6, (Object)string);
                arrayList.add(generalName);
            }
        }
        if (this.cuj != null && this.cuj.size() > 0) {
            for (n = 0; n < this.cuj.size(); ++n) {
                Object object2;
                string = (String)this.cuj.get(n);
                object = new byte[string.length() / 2];
                for (int j = 0; j < string.length(); j += 2) {
                    object2 = new BigInteger(string.substring(j, j + 2), 16);
                    object[j / 2] = ((Number)object2).byteValue();
                }
                sEQUENCE = new OCTET_STRING(object);
                object2 = new SEQUENCE();
                object2.addComponent((ASN1Object)this.cul);
                object2.addComponent((ASN1Object)new CON_SPEC(0, (ASN1Object)sEQUENCE));
                generalName = new GeneralName(0, object2);
                arrayList.add(generalName);
            }
        }
        if (this.cuk != null && this.cuk.size() > 0) {
            for (n = 0; n < this.cuk.size(); ++n) {
                string = (String)this.cuk.get(n);
                object = new UTF8String(string);
                sEQUENCE = new SEQUENCE();
                sEQUENCE.addComponent((ASN1Object)this.cum);
                sEQUENCE.addComponent((ASN1Object)new CON_SPEC(0, (ASN1Object)object));
                generalName = new GeneralName(0, (Object)sEQUENCE);
                arrayList.add(generalName);
            }
        }
        if (arrayList.size() > 0) {
            GeneralNames generalNames = new GeneralNames();
            for (int j = 0; j < arrayList.size(); ++j) {
                generalNames.addName((GeneralName)arrayList.get(j));
            }
            this.cuf = new SubjectAltName(generalNames);
            this.cuf.setCritical(this.critical);
        }
    }

    public String toString() {
        this.tn();
        return this.cuf.toString();
    }

    public static void main(String[] stringArray) {
        try {
            SubjectAlternativeNameExtension subjectAlternativeNameExtension = new SubjectAlternativeNameExtension();
            subjectAlternativeNameExtension.setDns("www.dns.pl");
            subjectAlternativeNameExtension.setEmail("swojcik@unizeto.pl");
            subjectAlternativeNameExtension.setEmail("s9wojcik@wp.pl");
            subjectAlternativeNameExtension.setUri("URI.uri.URI");
            subjectAlternativeNameExtension.setUpn("UPN.upn.UPN");
            String string = "e28a6a7ce4ca4db2bad40b3b5394e132";
            subjectAlternativeNameExtension.setGuid(string);
            subjectAlternativeNameExtension.getSubjectAltName();
            subjectAlternativeNameExtension.decode();
            System.out.println(subjectAlternativeNameExtension.toString());
            System.out.println(string.toUpperCase());
            System.out.println("*** KONIEC ***");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

