/*
 * Decompiled with CFR 0.152.
 */
package pl.unizeto.pki.cryptomanager;

import iaik.pkcs.pkcs12.CertificateBag;
import iaik.pkcs.pkcs12.KeyBag;
import iaik.pkcs.pkcs12.PKCS12;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import pl.unizeto.pki.cryptomanager.b;
import pl.unizeto.pki.cryptomanager.g;

public class e {
    private File file;
    private char[] password;
    private PKCS12 bZr;
    private InputStream is;
    private OutputStream os;

    public e(File file, char[] cArray) {
        this.file = file;
        this.password = cArray;
        this.is = new FileInputStream(file);
        this.bZr = new PKCS12(this.is);
        this.is.close();
        if (!this.bZr.verify(cArray)) {
            throw new g("Incorrecte password.");
        }
        this.bZr.decrypt(cArray);
    }

    public static boolean verifyPKCS12(File file) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            PKCS12 pKCS12 = new PKCS12((InputStream)fileInputStream);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public e(File file, char[] cArray, PrivateKey privateKey, X509Certificate[] x509CertificateArray) {
        this.file = file;
        this.password = cArray;
        byte[] byArray = null;
        CertificateBag[] certificateBagArray = new CertificateBag[x509CertificateArray.length];
        if (x509CertificateArray.length > 0) {
            byArray = x509CertificateArray[0].getSerialNumber().toByteArray();
        }
        for (int j = 0; j < x509CertificateArray.length; ++j) {
            certificateBagArray[j] = new CertificateBag((iaik.x509.X509Certificate)x509CertificateArray[j], null, x509CertificateArray[j].getSerialNumber().toByteArray());
        }
        this.bZr = new PKCS12(new KeyBag(privateKey, null, byArray), certificateBagArray);
        this.os = new FileOutputStream(file);
        this.bZr.encrypt(cArray);
        this.bZr.writeTo(this.os);
        this.os.close();
    }

    public X509Certificate[] getCertificate() {
        CertificateBag[] certificateBagArray = this.bZr.getCertificateBags();
        return CertificateBag.getCertificates((CertificateBag[])certificateBagArray);
    }

    public PrivateKey getPrivateKey() {
        KeyBag keyBag = this.bZr.getKeyBag();
        return keyBag.getPrivateKey();
    }

    public KeyPair getKeyPair() {
        PrivateKey privateKey = this.getPrivateKey();
        X509Certificate[] x509CertificateArray = this.getCertificate();
        if (x509CertificateArray == null) {
            throw new b("PKCS12 has no certificate.");
        }
        PublicKey publicKey = x509CertificateArray[x509CertificateArray.length - 1].getPublicKey();
        return new KeyPair(publicKey, privateKey);
    }

    public void setCerticicate(X509Certificate[] x509CertificateArray) {
        CertificateBag[] certificateBagArray = new CertificateBag[x509CertificateArray.length];
        for (int j = 0; j < x509CertificateArray.length; ++j) {
            certificateBagArray[j] = new CertificateBag((iaik.x509.X509Certificate)x509CertificateArray[j]);
        }
        PKCS12 pKCS12 = new PKCS12(this.bZr.getKeyBag(), certificateBagArray);
        this.os = new FileOutputStream(this.file);
        pKCS12.encrypt(this.password);
        pKCS12.writeTo(this.os);
        this.os.close();
        this.bZr = pKCS12;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        KeyBag keyBag = new KeyBag(privateKey);
        PKCS12 pKCS12 = new PKCS12(keyBag, this.bZr.getCertificateBags());
        this.os = new FileOutputStream(this.file);
        pKCS12.encrypt(this.password);
        pKCS12.writeTo(this.os);
        this.os.close();
        this.bZr = pKCS12;
    }
}

