/*
 * Decompiled with CFR 0.152.
 */
package pl.unizeto.pki.cryptomanager;

import iaik.security.provider.IAIK;
import iaik.x509.X509Certificate;
import iaik.x509.extensions.KeyUsage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;

public class KeyStoreService {
    private KeyStore keyStore;
    private OutputStream os;
    private char[] password;
    private File file;
    public static int KEYUSAGE_cRLSign = 64;
    public static int KEYUSAGE_dataEncipherment = 8;
    public static int KEYUSAGE_decipherOnly = 256;
    public static int KEYUSAGE_digitalSignature = 1;
    public static int KEYUSAGE_encipherOnly = 128;
    public static int KEYUSAGE_keyAgreement = 16;
    public static int KEYUSAGE_keyCertSign = 32;
    public static int KEYUSAGE_keyEncipherment = 4;
    public static int KEYUSAGE_nonRepudiation = 2;

    public KeyStoreService(File file, char[] cArray) {
        this.file = file;
        this.password = cArray;
        try {
            this.keyStore = KeyStore.getInstance("JKS", "SUN");
        }
        catch (Exception exception) {
            throw new KeyStoreException();
        }
        if (file.exists()) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                this.keyStore.load(fileInputStream, cArray);
            }
            catch (IOException iOException) {
                throw iOException;
            }
            finally {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            this.keyStore.load(null, null);
            this.keyStore.store(fileOutputStream, cArray);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    public String getNextAlias() {
        try {
            Vector vector = (Vector)this.getAliases();
            if (vector == null || vector.size() == 0) {
                return "0";
            }
            int n = 0;
            for (int j = 0; j < vector.size(); ++j) {
                Integer n2 = new Integer((String)vector.get(j));
                if (n2 <= n) continue;
                n = n2;
            }
            return Integer.toString(n + 1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "0";
        }
    }

    public Certificate findBySerialNo(BigInteger bigInteger) {
        Certificate[] certificateArray = this.getCertificates();
        for (int j = 0; j < certificateArray.length; ++j) {
            java.security.cert.X509Certificate x509Certificate = (java.security.cert.X509Certificate)certificateArray[j];
            if (!x509Certificate.getSerialNumber().equals(bigInteger)) continue;
            return certificateArray[j];
        }
        return null;
    }

    public String findAlias(Certificate certificate) {
        try {
            Vector vector = (Vector)this.getAliases();
            String string = null;
            for (int j = 0; j < vector.size(); ++j) {
                string = (String)vector.get(j);
                Certificate certificate2 = this.keyStore.getCertificate(string);
                if (!certificate2.equals(certificate)) continue;
                return string;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public Collection getAliases() {
        Enumeration<String> enumeration = this.keyStore.aliases();
        Vector<String> vector = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        return vector;
    }

    public Certificate getCertificate(String string) {
        return this.keyStore.getCertificate(string);
    }

    public Certificate[] getCertificates() {
        Certificate[] certificateArray = this.getCertificates(true);
        Certificate[] certificateArray2 = this.getCertificates(false);
        Certificate[] certificateArray3 = new Certificate[certificateArray.length + certificateArray2.length];
        System.arraycopy(certificateArray, 0, certificateArray3, 0, certificateArray.length);
        System.arraycopy(certificateArray2, 0, certificateArray3, certificateArray.length, certificateArray2.length);
        return certificateArray3;
    }

    public java.security.cert.X509Certificate[] getX509Certificates() {
        Vector vector = null;
        try {
            vector = (Vector)this.getAliases();
        }
        catch (KeyStoreException keyStoreException) {
            keyStoreException.printStackTrace();
            return null;
        }
        Vector<Certificate> vector2 = new Vector<Certificate>();
        for (int j = 0; j < vector.size(); ++j) {
            try {
                String string = (String)vector.elementAt(j);
                vector2.add(this.getCertificate(string));
                continue;
            }
            catch (KeyStoreException keyStoreException) {
                keyStoreException.printStackTrace();
            }
        }
        java.security.cert.X509Certificate[] x509CertificateArray = new java.security.cert.X509Certificate[vector2.size()];
        vector2.toArray(x509CertificateArray);
        return x509CertificateArray;
    }

    public Certificate[] getCertificates(boolean bl) {
        Vector vector;
        try {
            vector = (Vector)this.getAliases();
        }
        catch (KeyStoreException keyStoreException) {
            keyStoreException.printStackTrace();
            return null;
        }
        Vector<Certificate> vector2 = new Vector<Certificate>();
        for (int j = 0; j < vector.size(); ++j) {
            try {
                String string = (String)vector.elementAt(j);
                Certificate certificate = this.getCertificate(string);
                if (this.isCertificateEntry(string) != bl) continue;
                vector2.add(certificate);
                continue;
            }
            catch (KeyStoreException keyStoreException) {
                keyStoreException.printStackTrace();
            }
        }
        Certificate[] certificateArray = new Certificate[vector2.size()];
        vector2.toArray(certificateArray);
        return certificateArray;
    }

    public Certificate[] getCertificateChain(String string) {
        return this.keyStore.getCertificateChain(string);
    }

    public PrivateKey getPrivateKey(String string) {
        return (PrivateKey)this.keyStore.getKey(string, this.password);
    }

    public KeyPair getKeyPair(String string) {
        PrivateKey privateKey = this.getPrivateKey(string);
        Certificate[] certificateArray = this.getCertificateChain(string);
        if (certificateArray == null) {
            throw new KeyStoreException("Keystore has no certificate under this alias.");
        }
        PublicKey publicKey = certificateArray[0].getPublicKey();
        return new KeyPair(publicKey, privateKey);
    }

    public void setCertificate(String string, Certificate certificate) {
        this.keyStore.setCertificateEntry(string, certificate);
        this.os = new FileOutputStream(this.file);
        this.keyStore.store(this.os, this.password);
        this.os.close();
    }

    public void setPrivateKey(String string, PrivateKey privateKey, java.security.cert.X509Certificate[] x509CertificateArray) {
        this.keyStore.setKeyEntry(string, privateKey, this.password, x509CertificateArray);
        this.os = new FileOutputStream(this.file);
        this.keyStore.store(this.os, this.password);
        this.os.close();
    }

    public void removeCertificate(String string) {
        this.keyStore.deleteEntry(string);
        this.os = new FileOutputStream(this.file);
        this.keyStore.store(this.os, this.password);
        this.os.close();
    }

    public void removeCertificate(Certificate certificate) {
        String string = this.findAlias(certificate);
        if (string != null) {
            this.removeCertificate(string);
        }
    }

    public boolean isCertificateEntry(String string) {
        return this.keyStore.isCertificateEntry(string);
    }

    public boolean isKeyEntry(String string) {
        return this.keyStore.isKeyEntry(string);
    }

    public PrivateKey getPrivateKey(Certificate certificate) {
        String string = this.findAlias(certificate);
        if (string == null) {
            return null;
        }
        try {
            return this.getPrivateKey(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Certificate[] getCertificatesWithKeyUsage(int n) {
        int n2;
        switch (n) {
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: 
            case 32: 
            case 64: 
            case 128: 
            case 256: {
                break;
            }
            default: {
                throw new CertificateException("B??dny parametr u?ycia klucza.");
            }
        }
        Certificate[] certificateArray = this.getCertificates();
        if (certificateArray == null) {
            return null;
        }
        Vector<Certificate> vector = new Vector<Certificate>();
        for (n2 = 0; n2 < certificateArray.length; ++n2) {
            X509Certificate x509Certificate = (X509Certificate)certificateArray[n2];
            try {
                KeyUsage keyUsage = (KeyUsage)x509Certificate.getExtension(KeyUsage.oid);
                if ((keyUsage.get() & n) == 0) continue;
                vector.add(certificateArray[n2]);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (vector.size() == 0) {
            return null;
        }
        certificateArray = new Certificate[vector.size()];
        for (n2 = 0; n2 < certificateArray.length; ++n2) {
            certificateArray[n2] = (Certificate)vector.get(n2);
        }
        return certificateArray;
    }

    public static void main(String[] stringArray) {
        IAIK.addAsProvider((boolean)true);
        try {
            File file = new File("N:\\PKI\\BW_CryptoManager\\jce.keystore");
            KeyStoreService keyStoreService = new KeyStoreService(file, "123456".toCharArray());
            System.out.println("OK !");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

