/*
 * Decompiled with CFR 0.152.
 */
package a.a.a;

import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.x509.X509Certificate;
import iaik.x509.attr.IssuerSerial;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.Arrays;

public class g
implements ASN1Type {
    private OCTET_STRING cuV;
    private AlgorithmID cuW;
    private OCTET_STRING cuX;
    private IssuerSerial cuY;

    public g(X509Certificate x509Certificate) {
        this.setCertHash(x509Certificate);
        this.cuY = new IssuerSerial(x509Certificate);
    }

    public g(X509Certificate x509Certificate, AlgorithmID algorithmID) {
        this.setCertHash(x509Certificate, algorithmID);
        this.cuY = new IssuerSerial(x509Certificate);
    }

    public g(ASN1Object aSN1Object) {
        this.decode(aSN1Object);
    }

    public void decode(ASN1Object aSN1Object) {
        SEQUENCE sEQUENCE = (SEQUENCE)aSN1Object;
        int n = sEQUENCE.countComponents();
        int n2 = 1;
        if (sEQUENCE.getComponentAt(0) instanceof SEQUENCE) {
            SEQUENCE sEQUENCE2 = (SEQUENCE)sEQUENCE.getComponentAt(0);
            this.cuW = new AlgorithmID(sEQUENCE2.getComponentAt(0));
            this.cuX = (OCTET_STRING)sEQUENCE2.getComponentAt(1);
        } else if (sEQUENCE.getComponentAt(0) instanceof OCTET_STRING) {
            this.cuV = (OCTET_STRING)sEQUENCE.getComponentAt(0);
        }
        if (n > n2) {
            this.cuY = new IssuerSerial(sEQUENCE.getComponentAt(n2));
        }
    }

    public void setCertHash(X509Certificate x509Certificate) {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
        byte[] byArray = messageDigest.digest(x509Certificate.getEncoded());
        this.cuV = new OCTET_STRING(byArray);
    }

    public byte[] getOtherHashValue() {
        try {
            if (this.cuX != null) {
                return this.cuX.getWholeValue();
            }
            return null;
        }
        catch (IOException iOException) {
            throw new CodingException(iOException.getMessage());
        }
    }

    public byte[] getSha1HashValue() {
        try {
            if (this.cuV != null) {
                return this.cuV.getWholeValue();
            }
            return null;
        }
        catch (IOException iOException) {
            throw new CodingException(iOException.getMessage());
        }
    }

    public AlgorithmID getOtherHashAlgorithm() {
        return this.cuW;
    }

    public IssuerSerial getIssuerSerial() {
        return this.cuY;
    }

    public void setCertHash(X509Certificate x509Certificate, AlgorithmID algorithmID) {
        this.cuW = algorithmID;
        MessageDigest messageDigest = MessageDigest.getInstance(algorithmID.toString());
        byte[] byArray = messageDigest.digest(x509Certificate.getEncoded());
        this.cuX = new OCTET_STRING(byArray);
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        if (this.cuV != null) {
            sEQUENCE.addComponent((ASN1Object)this.cuV);
        } else if (this.cuW != null) {
            sEQUENCE.addComponent(this.cuW.toASN1Object());
            sEQUENCE.addComponent((ASN1Object)this.cuX);
        }
        if (this.cuY != null) {
            sEQUENCE.addComponent(this.cuY.toASN1Object());
        }
        return sEQUENCE;
    }

    public boolean identifiesCert(X509Certificate x509Certificate) {
        try {
            if (this.cuV != null) {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
                byte[] byArray = messageDigest.digest(x509Certificate.getEncoded());
                if (Arrays.equals(this.cuV.getWholeValue(), byArray)) {
                    return true;
                }
            } else if (this.cuX != null) {
                MessageDigest messageDigest = MessageDigest.getInstance(this.cuW.toString());
                byte[] byArray = messageDigest.digest(x509Certificate.getEncoded());
                if (Arrays.equals(this.cuX.getWholeValue(), byArray)) {
                    return true;
                }
            }
        }
        catch (IOException iOException) {
            throw new CodingException(iOException.getMessage());
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.cuY != null) {
            if (!stringBuffer.toString().equals("")) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.cuY.toString());
        }
        return stringBuffer.toString();
    }
}

